var sMaxArticleCountOnPage = 10;
var sPageListID = "pagelist"
var sArticleListID = "articlelist"
var sCurrentPageIndex = 0;
var sShouldShowArticle = 0;
var sSearchRange;
var sfilterWords;

var sNextCount = 0;
var sMaxPageListCount  = 10;
var sFirstPageNum = 1;
var pageListCount;

var exButton= null;

function Search()
{
	filterString = t1.value;
	filterString = filterString.toLocaleLowerCase();
		
	if(!sfilterWords)
		sfilterWords = new Array();
		
	sfilterWords = (filterString+" ").match(/(\S+)(?=\s)/g);

	if(!sSearchRange)
		sSearchRange = document.createRange();

	sCurrentPageIndex = 0;
	UpdateDocument();	
}

function SelectListButton(button)
{
    sCurrentPageIndex = button.firstChild.nodeValue - 1;
    if(exButton)
      exButton.bgColor = "white";
    button.bgColor = "rgb(116, 197, 231)";
  	UpdateArticleList();
  	exButton = button;
}

function shouldShowArticle( article )
{
	if(!sfilterWords || !sSearchRange)
		return true;

	sSearchRange.selectNodeContents(article);
	text = sSearchRange.toString();

	text = text.toLocaleLowerCase()
	for( var i=sfilterWords.length-1; i>=0; i-- )
	{
		var string = sfilterWords[i];
		var start = 0;
		while(true)
		{
			start = text.indexOf(string,start);
			if( start < 0 )
				return false;// didn't find this string
            
			if( start==0 )
				break;                          // found at start of text -- matches
			
			var prev = text.charAt(start-1);
			if( prev <= '~' )
			{
				if( prev<'0' || (prev>'9' && prev<'a') || prev>'z' )
					break;                      // found at start of word -- matches
			}
			else if( prev >= '\u3000' && prev <= '\u303F' )
			{
				break;                          // CJK symbols and punctuation
			}
			else if( prev >= '\u5000' && prev <= '\u9FFF' )
			{
				break;                          // Chinese/Japanese characters (there are no word breaks)
			}
			else
			{
       }
				// This instance wasn't at the start of a word; search for next instance...
            
			start += string.length;
		}
	}
   return true;
}

function UpdateArticleList()
{
	sShouldShowArticle = 0;
  var articles = document.getElementById(sArticleListID).childNodes;
	count = -sCurrentPageIndex * sMaxArticleCountOnPage;

  for( var i=0; i<articles.length; i++ )
	{
		var article = articles[i];

		if( article.nodeName == 'DIV' )
		{
			if( shouldShowArticle(article) )
			{
				// Article  
				if( 0 <= count && count < sMaxArticleCountOnPage )
					article.style.display = "";
				else
					article.style.display = 'none';

				count++;
				sShouldShowArticle++;
			}
			else 
	        
			{
				article.style.display = 'none';
			}
		}
	}
}

function UpdateDocument()
{
	UpdateArticleList();
	pageListCount = calcPageListCount();
	UpdateArticlePageList(sFirstPageNum, 1);
}

function UpdateArticlePageList(pageNum, currentButton)
{
	var pagelistbuttons = document.getElementById(sPageListID).childNodes;

 if(exButton)
    exButton.bgColor = "white";
    
 	var buttonCount = 0;
  for( var i=0; i<pagelistbuttons.length; i++ )
	{
		var button = pagelistbuttons[i];
		if(button.nodeName =='TD')
		{
		  button.firstChild.nodeValue = pageNum;
			if( pageNum <= pageListCount && buttonCount < sMaxPageListCount)		
			{
  			  button.style.display = "";
			}
			else
			  	button.style.display = 'none';

			pageNum++;
			if(++buttonCount == currentButton)
			{
			 pagelistbuttons[i].bgColor = "rgb(116, 197, 231)";
			 exButton = pagelistbuttons[i];
			}
		}
	}
}

function NextPageList()
{
  var pageNum;
 	var currentButton = 0;

	if( sFirstPageNum + sMaxPageListCount > pageListCount)
    return;
    
  pageNum = sFirstPageNum + sMaxPageListCount;

  sFirstPageNum = pageNum;
  sCurrentPageIndex = sFirstPageNum - 1;
	UpdateArticleList();
  UpdateArticlePageList(pageNum, 1);
  
}
function PrePageList()
{
	var pageNum;

  if( sFirstPageNum - sMaxPageListCount < 1)
    return;
    
  pageNum = sFirstPageNum - sMaxPageListCount;

  sFirstPageNum = pageNum;
  sCurrentPageIndex = sFirstPageNum + sMaxPageListCount - 2;
	UpdateArticleList();
  UpdateArticlePageList(pageNum, sMaxPageListCount);
}

function calcPageListCount()
{  
  var pageListCount;

  if(sShouldShowArticle % sMaxArticleCountOnPage == 0)
    pageListCount = sShouldShowArticle / sMaxArticleCountOnPage;
  else
    pageListCount = sShouldShowArticle / sMaxArticleCountOnPage + 1;

  return pageListCount;
}
